IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_SALDO_CREDIARIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_SALDO_CREDIARIO]  
GO

CREATE PROCEDURE [dbo].[P_ATUALIZA_SALDO_CREDIARIO] (    
            @IN_CD_EMP  INT = 1,    
            @IN_CD_CLI  INT = 0) WITH ENCRYPTION AS    
    
CREATE TABLE #RS_SLD   (CD_EMP		INT,     
						  CD_CLI	INT,     
						  VLR_LIM_CRED MONEY,    
						  VLR_DEB_CRED MONEY,    
						  VLR_DEB_PARC_CRED MONEY,    
						  VLR_DEB_FAT_CRED MONEY)  

CREATE TABLE #RS_SLD_DP   (CD_EMP		INT,     
							  CD_CLI	INT,     
							  VLR_LIM_CRED MONEY,    
							  VLR_DEB_CRED MONEY,    
							  VLR_DEB_PARC_CRED MONEY,    
							  VLR_DEB_FAT_CRED MONEY)  	    
    
CREATE TABLE #RS_CLI_PROC (CD_EMP INT, CD_CLI INT, VLR_LIM_CRED MONEY)    
    
DECLARE @CD_EMP INT    
DECLARE @CD_CLI INT    
DECLARE @VLR_LIM_CRED MONEY    
DECLARE @VLR_DEB_CRED MONEY    
DECLARE @VLR_DEB_PARC_CRED MONEY    
DECLARE @VLR_DEB_FAT_CRED MONEY    
DECLARE @FLAG_LIMITE_CREDIARIO_POR INT

SET @FLAG_LIMITE_CREDIARIO_POR = ISNULL((SELECT 
												VALOR AS ORC_PED_CP
											FROM 
												PRC_EMP_CONFIG
											WHERE 
												CD_EMP = @IN_CD_EMP 
												AND	CD_CHAVE = 'LIMITE_CREDIARIO_POR'),0);

    
--Zerado os saldo de todos os clientes    
--foi criado um cursor para nao travar os demais usuarios do sistema    
--pois estaremos atualizando linha a linha    
SET NOCOUNT ON    
--Rodar Cliente individualmente    
IF @IN_CD_CLI > 0     
BEGIN    
	INSERT INTO #RS_CLI_PROC    
	SELECT     
		CD_EMP,     
		CD_CLI,    
		VLR_LIM_CRED    
	FROM     
		RC_CLI_CREDIARIO     
	WHERE      
		CD_EMP  = @IN_CD_EMP    
		AND CD_CLI = @IN_CD_CLI   
    
END    
    
--Rodar os clientes pendente de realizacao de totalizador de saldo    
IF @IN_CD_CLI = 0     
BEGIN    
	INSERT INTO #RS_CLI_PROC     
	SELECT     
		RC_CLI_CREDIARIO_PENDENTE_SALDO.CD_EMP,     
		RC_CLI_CREDIARIO_PENDENTE_SALDO.CD_CLI,    
		VLR_LIM_CRED    
	FROM     
		RC_CLI_CREDIARIO_PENDENTE_SALDO INNER JOIN RC_CLI_CREDIARIO ON    
		RC_CLI_CREDIARIO_PENDENTE_SALDO.CD_EMP = RC_CLI_CREDIARIO.CD_EMP AND    
		RC_CLI_CREDIARIO_PENDENTE_SALDO.CD_CLI = RC_CLI_CREDIARIO.CD_CLI   
  
END    
    IF NOT EXISTS (SELECT 1 FROM #RS_CLI_PROC )
		BEGIN 
		RETURN
		END 
	ELSE
DECLARE Crediario CURSOR FAST_FORWARD FOR 
SELECT 
	CD_EMP, 
	CD_CLI     
FROM     
	#RS_CLI_PROC    
    
OPEN Crediario    
FETCH NEXT FROM Crediario INTO @CD_EMP, @CD_CLI    
    
WHILE @@FETCH_STATUS=0    
	Begin    
		UPDATE    
			RC_CLI_CREDIARIO     
		SET    
			VLR_DEB_CRED = 0,    
			VLR_DEB_PARC_CRED = 0,    
			VLR_DEB_FAT_CRED = 0    
		WHERE    
			CD_CLI  = @CD_CLI    
			AND CD_EMP = @CD_EMP    
    
		--Proximo registro    
		FETCH NEXT FROM Crediario INTO @CD_EMP, @CD_CLI    
	End    
    
--Fechando cursos    
CLOSE Crediario;    
    
--Desalocando cursos da memoria    
DEALLOCATE Crediario;    
 
IF @FLAG_LIMITE_CREDIARIO_POR = 0 
BEGIN
	INSERT INTO #RS_SLD
	SELECT
		RC_DEB.CD_EMP,
		RC_DEB.CD_CLI,
		0,
		SUM(RC_DEB.SLD_DP),
		0,
		0
	 FROM
		RC_DEB 
		INNER JOIN #RS_CLI_PROC c ON    
		RC_DEB.CD_EMP = c.CD_EMP AND    
		RC_DEB.CD_CLI = c.CD_CLI    
	     LEFT JOIN RC_DEB_PAG ON 
		  dbo.RC_DEB.CD_EMP=dbo.RC_DEB_PAG.CD_EMP AND
		  dbo.RC_DEB.CD_FILIAL=dbo.RC_DEB_PAG.CD_FILIAL AND
		  dbo.RC_DEB.CD_RC_DEB=dbo.RC_DEB_PAG.CD_RC_DEB
	 WHERE
		RC_DEB.CD_EMP  = @IN_CD_EMP    
		AND RC_DEB.STS_DP IN (0,2,5)
		AND (dbo.RC_DEB_PAG.CD_EMP IS NULL)
	 GROUP BY
		RC_DEB.CD_EMP,
		RC_DEB.CD_CLI	    
END    
--Buscando o saldo de vendas dos clientes credirio    
	INSERT INTO #RS_SLD     
	SELECT     
		RC_CREDIARIO_PARC.CD_EMP,    
		RC_CREDIARIO_PARC.CD_CLI,    
		c.VLR_LIM_CRED,    
		ISNULL(SUM(SLD_PARC_CRED),0) AS VLR_PARC_CRED,    
		ISNULL(SUM((CASE WHEN DT_FECHA_CRED <= DBO.F_DIA_PREV_FECHA_VENC_CRED (RC_CREDIARIO_PARC.CD_EMP, RC_CREDIARIO_PARC.CD_CLI, CONVERT(VARCHAR(10), GETDATE(), 101),1,0) AND QT_PARC_VD_CRED > 1 THEN     
			CASE WHEN CONVERT(CHAR(6), DT_FECHA_CRED, 112) <> CONVERT(CHAR(6), DBO.F_DIA_PREV_FECHA_VENC_CRED (RC_CREDIARIO_PARC.CD_EMP, RC_CREDIARIO_PARC.CD_CLI, CONVERT(VARCHAR(10), GETDATE(), 101),1,0),112) THEN    
			SLD_PARC_CRED     
			ELSE         
			0    
			END    
		ELSE     
			0     
		END)),0) AS VLR_DEB_PARC_CRED,    
    
		ISNULL(SUM((CASE WHEN DT_FECHA_CRED <= DBO.F_DIA_PREV_FECHA_VENC_CRED (RC_CREDIARIO_PARC.CD_EMP, RC_CREDIARIO_PARC.CD_CLI, CONVERT(VARCHAR(10), GETDATE(), 101),1,0) THEN     
			SLD_PARC_CRED     
		ELSE     
			0     
		END)),0) AS VLR_DEB_FAT_CRED    
	FROM     
		RC_CREDIARIO_PARC 
		INNER JOIN #RS_CLI_PROC c ON    
		RC_CREDIARIO_PARC.CD_EMP = c.CD_EMP AND    
		RC_CREDIARIO_PARC.CD_CLI = c.CD_CLI    
	WHERE     
		RC_CREDIARIO_PARC.CD_EMP  = @IN_CD_EMP    
		AND RC_CREDIARIO_PARC.STS_LANC_CRED IN (0,5,9)   
		AND case when @IN_CD_CLI =0 then 
				C.CD_CLI else @IN_CD_CLI end =C.CD_CLI

	GROUP BY    
		RC_CREDIARIO_PARC.CD_EMP,    
		RC_CREDIARIO_PARC.CD_CLI,    
		c.VLR_LIM_CRED    

	INSERT INTO #RS_SLD_DP
	SELECT
		RC_DEB.CD_EMP,
		RC_DEB.CD_CLI,
		0 as VLR_LIM_CRED ,
		SUM(RC_DEB.SLD_DP) as VLR_DEB_CRED,
		0 as VLR_DEB_PARC_CRED,
		SUM(RC_DEB.SLD_DP) as VLR_DEB_FAT_CRED
	FROM
		RC_DEB
		INNER JOIN rc_cli_crediario c ON    
		RC_DEB.CD_EMP = c.CD_EMP AND    
		RC_DEB.CD_CLI = c.CD_CLI   
	
		INNER JOIN RC_MDL_VENDA MDL ON
		MDL.CD_EMP=C.CD_EMP AND
		MDL.CD_MDL_VD=C.CD_MDL_VD 
	     LEFT JOIN RC_DEB_PAG ON 
		  dbo.RC_DEB.CD_EMP=dbo.RC_DEB_PAG.CD_EMP AND
		  dbo.RC_DEB.CD_FILIAL=dbo.RC_DEB_PAG.CD_FILIAL AND
		  dbo.RC_DEB.CD_RC_DEB=dbo.RC_DEB_PAG.CD_RC_DEB
	WHERE
		RC_DEB.CD_EMP  = 1    
		AND RC_DEB.STS_DP IN (0,2,5)
		AND case when @IN_CD_CLI =0 then 
				C.CD_CLI else @IN_CD_CLI end =C.CD_CLI
		AND MDL.FLAG_DEB_FAT_SLD=1 
		AND ( dbo.RC_DEB_PAG.CD_EMP IS NULL)
		--AND MDL.TP_FECHA= 1 
		--AND MDL.DIA_FECHA=1
	GROUP BY
		RC_DEB.CD_EMP,
		RC_DEB.CD_CLI	 

		 
		 
-----------------------------------------------------------------------------------    
 
DECLARE CrediarioSaldo CURSOR FAST_FORWARD FOR 
	SELECT 
		A.CD_EMP, 
		A.CD_CLI, 
		SUM(A.VLR_LIM_CRED), 
		SUM(A.VLR_DEB_CRED), 
		SUM(A.VLR_DEB_PARC_CRED) , 
		SUM(A.VLR_DEB_FAT_CRED) 				
	FROM 
		(SELECT 
			A.CD_EMP, 
			A.CD_CLI, 
			SUM(A.VLR_LIM_CRED) VLR_LIM_CRED, 
			SUM(A.VLR_DEB_CRED) VLR_DEB_CRED, 
			SUM(A.VLR_DEB_PARC_CRED)  VLR_DEB_PARC_CRED  , 
			SUM(A.VLR_DEB_FAT_CRED) VLR_DEB_FAT_CRED

		FROM 
			#RS_SLD A 
		GROUP BY 
			A.CD_EMP, 
			A.CD_CLI 
		union SELECT 
			A.CD_EMP, 
			A.CD_CLI, 
			0 VLR_LIM_CRED, 
			0 VLR_DEB_CRED, 
			0 VLR_DEB_PARC_CRED, 
			SUM(A.VLR_DEB_FAT_CRED) 	
		FROM 
			#RS_SLD_DP A 
		GROUP BY 
			A.CD_EMP, 
			A.CD_CLI) A 
	GROUP BY 
		A.CD_EMP, 
		A.CD_CLI 

OPEN CrediarioSaldo    
    
FETCH NEXT FROM CrediarioSaldo INTO @CD_EMP, @CD_CLI, @VLR_LIM_CRED, @VLR_DEB_CRED, @VLR_DEB_PARC_CRED, @VLR_DEB_FAT_CRED    
WHILE @@FETCH_STATUS=0    
	Begin    

		UPDATE    
			RC_CLI_CREDIARIO    
		SET       
			VLR_DEB_CRED  = @VLR_DEB_CRED,       
			VLR_DEB_PARC_CRED = @VLR_DEB_PARC_CRED,    
			VLR_DEB_FAT_CRED = @VLR_DEB_FAT_CRED    
		WHERE    
			CD_EMP  = @CD_EMP    
			AND CD_CLI = @CD_CLI    
			AND (VLR_DEB_CRED + VLR_DEB_PARC_CRED + VLR_DEB_FAT_CRED)  <> (@VLR_DEB_CRED + @VLR_DEB_PARC_CRED + @VLR_DEB_FAT_CRED)    
    
		--Proximo registro    
		FETCH NEXT FROM CrediarioSaldo INTO @CD_EMP, @CD_CLI, @VLR_LIM_CRED, @VLR_DEB_CRED, @VLR_DEB_PARC_CRED, @VLR_DEB_FAT_CRED    
	End    
    
--Deletando clientes ja processados    
DECLARE CrediarioDeleteProc CURSOR FAST_FORWARD FOR SELECT DISTINCT CD_EMP, CD_CLI FROM #RS_CLI_PROC    
OPEN CrediarioDeleteProc    
    
FETCH NEXT FROM CrediarioDeleteProc INTO @CD_EMP, @CD_CLI    
WHILE @@FETCH_STATUS=0    
	Begin    
		DELETE FROM    
			RC_CLI_CREDIARIO_PENDENTE_SALDO    
		WHERE    
			CD_CLI = @CD_CLI     
			AND CD_EMP = @CD_EMP     
		--Proximo registro    
		FETCH NEXT FROM CrediarioDeleteProc INTO @CD_EMP, @CD_CLI    
	End    
     
--Fechando cursos    
CLOSE CrediarioSaldo;    
CLOSE CrediarioDeleteProc;    
    
--Desalocando cursos da memoria    
    
DEALLOCATE CrediarioSaldo;    
DEALLOCATE CrediarioDeleteProc;    
DROP TABLE #RS_SLD;    
DROP TABLE #RS_CLI_PROC;





GO


